

#include <stdlib.h>
#include <sys/stat.h>

enum fnc_state { s_DIR, s_SLASH, s_BASE, s_TRAILING };
enum fnc_type { t_PATH, t_ITEM };


typedef unsigned char uchar;

// Taken from https://github.com/RsyncProject/rsync/blob/9615a2492bbf96bc145e738ebff55bbb91e0bbee/flist.c#L3204
// rsync uses it's own fname_cmp function to sort the file list.
// This is a copy of the function with some modifications to make it work with our data structures
int f_name_cmp(
  char *dirname1,
  char *dirname2,
  char *basename1,
  char *basename2,
  int mode1,
  int mode2,
  int protocol_version
)
{
    int dif;
    const uchar *c1, *c2;
    enum fnc_state state1, state2;
    enum fnc_type type1, type2;
    enum fnc_type t_path = protocol_version >= 29 ? t_PATH : t_ITEM;


    c1 = (uchar*)dirname1;
    c2 = (uchar*)dirname2;
    if (c1 == c2)
        c1 = c2 = NULL;
    if (!c1) {
        type1 = S_ISDIR(mode1) ? t_path : t_ITEM;
        c1 = (const uchar*)basename1;
        if (type1 == t_PATH && *c1 == '.' && !c1[1]) {
            type1 = t_ITEM;
            state1 = s_TRAILING;
            c1 = (uchar*)"";
        } else
            state1 = s_BASE;
    } else {
        type1 = t_path;
        state1 = s_DIR;
    }
    if (!c2) {
        type2 = S_ISDIR(mode2) ? t_path : t_ITEM;
        c2 = (const uchar*)basename2;
        if (type2 == t_PATH && *c2 == '.' && !c2[1]) {
            type2 = t_ITEM;
            state2 = s_TRAILING;
            c2 = (uchar*)"";
        } else
            state2 = s_BASE;
    } else {
        type2 = t_path;
        state2 = s_DIR;
    }

    if (type1 != type2)
        return type1 == t_PATH ? 1 : -1;

    do {
        if (!*c1) {
            switch (state1) {
            case s_DIR:
                state1 = s_SLASH;
                c1 = (uchar*)"/";
                break;
            case s_SLASH:
                type1 = S_ISDIR(mode1) ? t_path : t_ITEM;
                c1 = (const uchar*)basename1;
                if (type1 == t_PATH && *c1 == '.' && !c1[1]) {
                    type1 = t_ITEM;
                    state1 = s_TRAILING;
                    c1 = (uchar*)"";
                } else
                    state1 = s_BASE;
                break;
            case s_BASE:
                state1 = s_TRAILING;
                if (type1 == t_PATH) {
                    c1 = (uchar*)"/";
                    break;
                }
                /* FALL THROUGH */
            case s_TRAILING:
                type1 = t_ITEM;
                break;
            }
            if (*c2 && type1 != type2)
                return type1 == t_PATH ? 1 : -1;
        }
        if (!*c2) {
            switch (state2) {
            case s_DIR:
                state2 = s_SLASH;
                c2 = (uchar*)"/";
                break;
            case s_SLASH:
                type2 = S_ISDIR(mode2) ? t_path : t_ITEM;
                c2 = (const uchar*)basename2;
                if (type2 == t_PATH && *c2 == '.' && !c2[1]) {
                    type2 = t_ITEM;
                    state2 = s_TRAILING;
                    c2 = (uchar*)"";
                } else
                    state2 = s_BASE;
                break;
            case s_BASE:
                state2 = s_TRAILING;
                if (type2 == t_PATH) {
                    c2 = (uchar*)"/";
                    break;
                }
            /* FALL THROUGH */
            case s_TRAILING:
                if (!*c1)
                    return 0;
                type2 = t_ITEM;
                break;
            }
            if (type1 != type2)
                return type1 == t_PATH ? 1 : -1;
        }
    } while ((dif = (int)*c1++ - (int)*c2++) == 0);

    return dif;
}